#include <stdio.h>
#include <stdlib.h>

#define MAXN 100010

int poderes[MAXN][MAXN], resp[MAXN][MAXN], ativo[MAXN][MAXN], indice[MAXN][MAXN];
int pai[MAXN], soma[MAXN];
int dx[] = {0, 1, 0, -1};
int dy[] = {1, 0, -1, 0};
int componente[MAXN][MAXN];

typedef struct {
    int linha, coluna, poder;
} Celula;

int compare(const void *a, const void *b) {
    return ((Celula*)a)->poder - ((Celula*)b)->poder;
}

int find(int v) {
    if (pai[v] == v)
        return v;
    pai[v] = find(pai[v]);  // Compressão de caminho
    return pai[v];
}

void une(int a, int b) {
    a = find(a);
    b = find(b);

    if (a == b) return;

    if (componente[a] > componente[b]) {
        int temp = a;
        a = b;
        b = temp;
    }

    for (int i = 0; i < componente[a]; i++) {
        resp[componente[a]][componente[i]] = soma[a];
    }

    pai[a] = b;
    soma[b] += soma[a];
    componente[a] = 0;
}

int main() {
    while (1) {
        int n, m;
        scanf("%d %d", &n, &m);

        if (n == 0 && m == 0) break;

        Celula celulas[MAXN];
        int id_counter = 0;

        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                int p;
                scanf("%d", &p);
                poderes[i][j] = p;
                Celula nova = {i, j, p};
                celulas[id_counter++] = nova;
                indice[i][j] = id_counter;
                ativo[i][j] = 0;
                resp[i][j] = 0;
            }
        }

        qsort(celulas, n * m, sizeof(Celula), compare);

        for (int i = 0; i < n * m; i++) {
            Celula c = celulas[i];
            int l = c.linha, c1 = c.coluna, p = c.poder;
            ativo[l][c1] = 1;
            int id = indice[l][c1] - 1;

            for (int k = 0; k < 4; k++) {
                int vizl = l + dx[k];
                int vizc = c1 + dy[k];
                if (vizl < 0 || vizl >= n || vizc < 0 || vizc >= m) continue;
                if (ativo[vizl][vizc] == 0) continue;

                int vizid = indice[vizl][vizc] - 1;
                if (p <= soma[vizid]) {
                    une(id, vizid);
                } else {
                    for (int t = 0; t < componente[vizid]; t++) {
                        resp[componente[vizid]][componente[vizid]] = soma[vizid];
                    }
                    componente[vizid] = 0;
                    une(vizid, id);
                }
            }
        }

        // Imprime a saída
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                printf("%d ", resp[i][j]);
            }
            printf("\n");
        }
    }
    return 0;
}
